/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.Messages;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

class GitMoveDeleteHook
implements IMoveDeleteHook {
    static final Status CANNOT_MODIFY_REPO = new Status(4, GitPlugin.getPluginId(), 0, Messages.GitMoveDeleteHook_CannotModifyRepository_ErrorMessage, null);
    private static final boolean I_AM_DONE = true;

    GitMoveDeleteHook() {
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        IStatus status;
        boolean force;
        boolean bl = force = (updateFlags & 1) == 1;
        if (!force && !tree.isSynchronized((IResource)file, 0)) {
            return false;
        }
        GitRepository repo = this.getAttachedGitRepository(file.getProject());
        if (repo == null) {
            return false;
        }
        ChangedFile changed = repo.getChangedFileForResource((IResource)file);
        if (changed == null || changed.getStatus() == ChangedFile.Status.NEW) {
            return false;
        }
        if ((updateFlags & 2) == 2) {
            tree.addToLocalHistory(file);
        }
        if ((status = repo.deleteFile(changed.getRelativePath())).isOK()) {
            tree.deletedFile(file);
        } else {
            tree.failed(status);
        }
        return true;
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        IStatus status;
        boolean force;
        boolean bl = force = (updateFlags & 1) == 1;
        if (!force && !tree.isSynchronized((IResource)folder, 2)) {
            return false;
        }
        GitRepository repo = this.getAttachedGitRepository(folder.getProject());
        if (repo == null) {
            return false;
        }
        if (folder.getName().equals(".git")) {
            return this.cannotModifyRepository(tree);
        }
        IPath source = this.getRepoRelativePath((IResource)folder, repo);
        if (this.hasNoCommittedFiles(source, repo)) {
            return false;
        }
        if ((updateFlags & 2) == 2) {
            this.addFilesToLocalHistoryRecursively(tree, (IContainer)folder);
        }
        if ((status = repo.deleteFolder(source)).isOK()) {
            tree.deletedFolder(folder);
        } else if (this.noMatchingFiles(status)) {
            tree.standardDeleteFolder(folder, updateFlags, monitor);
        } else {
            tree.failed(status);
        }
        return true;
    }

    protected boolean noMatchingFiles(IStatus status) {
        return status.getCode() == 128 && status.getMessage().endsWith("did not match any files");
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        boolean force;
        IPath source;
        GitRepository repo = this.getAttachedGitRepository(project);
        if (repo == null) {
            return false;
        }
        boolean alwaysDeleteContent = (updateFlags & 4) != 0;
        try {
            if (repo.workingDirectory().toFile().getCanonicalPath().equals(project.getLocation().toFile().getCanonicalPath())) {
                IFolder gitDir;
                this.getGitRepositoryManager().removeRepository(project);
                if (alwaysDeleteContent && (gitDir = project.getFolder(".git")).exists()) {
                    tree.standardDeleteFolder(gitDir, updateFlags | 1, (IProgressMonitor)new NullProgressMonitor());
                    tree.deletedFolder(gitDir);
                }
                return false;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)"File.getCanonicalPath failed.", (Throwable)e, (String)"com.aptana.git.core/debug");
        }
        if (this.hasNoCommittedFiles(source = this.getRepoRelativePath((IResource)project, repo), repo)) {
            return false;
        }
        boolean bl = force = alwaysDeleteContent || (updateFlags & 1) == 1;
        if (force) {
            updateFlags |= 1;
        }
        if (!force && !tree.isSynchronized((IResource)project, 2)) {
            return false;
        }
        boolean neverDeleteContent = (updateFlags & 8) != 0;
        boolean deleteContents = alwaysDeleteContent || project.isOpen() && !neverDeleteContent;
        IStatus status = Status.OK_STATUS;
        if (deleteContents) {
            status = repo.deleteFolder(source);
        }
        if (status.isOK()) {
            tree.deletedProject(project);
        } else if (this.noMatchingFiles(status)) {
            tree.standardDeleteProject(project, updateFlags, monitor);
        } else {
            tree.failed(status);
        }
        return true;
    }

    public boolean moveFile(IResourceTree tree, IFile srcf, IFile dstf, int updateFlags, IProgressMonitor monitor) {
        IPath dest;
        IPath source;
        IStatus status;
        boolean force;
        boolean bl = force = (updateFlags & 1) == 1;
        if (!force && !tree.isSynchronized((IResource)srcf, 0)) {
            return false;
        }
        GitRepository repo = this.getAttachedGitRepository(srcf.getProject());
        if (repo == null) {
            return false;
        }
        GitRepository dstm = this.getAttachedGitRepository(dstf.getProject());
        if (dstm == null || !dstm.equals(repo)) {
            return false;
        }
        ChangedFile changed = repo.getChangedFileForResource((IResource)srcf);
        if (changed == null || changed.getStatus() == ChangedFile.Status.NEW) {
            return false;
        }
        if ((updateFlags & 2) == 2) {
            tree.addToLocalHistory(srcf);
        }
        if ((status = repo.moveFile(source = this.getRepoRelativePath((IResource)srcf, repo), dest = this.getRepoRelativePath((IResource)dstf, repo))).isOK()) {
            tree.movedFile(srcf, dstf);
        } else {
            tree.failed(status);
        }
        return true;
    }

    public boolean moveFolder(IResourceTree tree, IFolder srcf, IFolder dstf, int updateFlags, IProgressMonitor monitor) {
        IPath dest;
        IStatus status;
        GitRepository repo = this.getAttachedGitRepository(srcf.getProject());
        if (repo == null) {
            return false;
        }
        GitRepository dstm = this.getAttachedGitRepository(dstf.getProject());
        if (dstm == null || !dstm.equals(repo)) {
            return false;
        }
        IPath source = this.getRepoRelativePath((IResource)srcf, repo);
        if (this.hasNoCommittedFiles(source, repo)) {
            return false;
        }
        if ((updateFlags & 2) == 2) {
            this.addFilesToLocalHistoryRecursively(tree, (IContainer)srcf);
        }
        if ((status = repo.moveFile(source, dest = this.getRepoRelativePath((IResource)dstf, repo))).isOK()) {
            tree.movedFolderSubtree(srcf, dstf);
        } else {
            tree.failed(status);
        }
        return true;
    }

    protected boolean hasNoCommittedFiles(IPath source, GitRepository repo) {
        IStatus result = repo.execute(GitRepository.ReadWrite.READ, "ls-tree", "-r", "HEAD:" + source.toOSString());
        return result == null || !result.isOK();
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        IStatus status;
        GitRepository repo = this.getAttachedGitRepository(source);
        if (repo == null) {
            return false;
        }
        IPath workingDirectory = repo.workingDirectory();
        if (workingDirectory.equals((Object)source.getLocation())) {
            this.getGitRepositoryManager().removeRepository(source);
            tree.standardMoveProject(source, description, updateFlags, monitor);
            try {
                this.getGitRepositoryManager().attachExisting(source, monitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return true;
        }
        IPath destPath = description.getLocation();
        if (destPath == null) {
            destPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(description.getName());
        }
        if (!workingDirectory.isPrefixOf(destPath)) {
            this.getGitRepositoryManager().removeRepository(source);
            tree.standardMoveProject(source, description, updateFlags, monitor);
            return true;
        }
        destPath = destPath.makeRelativeTo(workingDirectory);
        IPath sourcePath = this.getRepoRelativePath((IResource)source, repo);
        if (this.hasNoCommittedFiles(sourcePath, repo)) {
            return false;
        }
        if ((updateFlags & 2) == 2) {
            this.addFilesToLocalHistoryRecursively(tree, (IContainer)source);
        }
        if ((status = repo.moveFile(sourcePath, destPath)).isOK()) {
            tree.movedProjectSubtree(source, description);
        } else {
            tree.failed(status);
        }
        return true;
    }

    private boolean cannotModifyRepository(IResourceTree tree) {
        tree.failed((IStatus)CANNOT_MODIFY_REPO);
        return true;
    }

    private IPath getRepoRelativePath(IResource file, GitRepository repo) {
        return repo.relativePath(file);
    }

    protected GitRepository getAttachedGitRepository(IProject project) {
        return this.getGitRepositoryManager().getAttached(project);
    }

    protected IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    protected void addFilesToLocalHistoryRecursively(final IResourceTree tree, IContainer folder) {
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFile) {
                        tree.addToLocalHistory((IFile)resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
    }
}

